RORHL121 ;HOIFO/BH - HL7 MICROBIOLOGY DATA: OBX ; 8/31/05 1:16pm
 ;;1.5;CLINICAL CASE REGISTRIES;;Feb 17, 2006
 ;
 Q
 ;
FUNGUS ;***** Process Fungus/Yeast
 N FYIEN,RORFYIEN,RORFYID,RORFYCM
 ;
 S RORFYID=$$SEGID("FUNG","Fungus-Yeast",CS)
 S RORFYCM=$$SEGID("FUNGC","F-Y Comment",CS)
 S RORFYIEN=""
 F  S RORFYIEN=$O(@RORREF@(9,RORFYIEN))  Q:'RORFYIEN  D
 . S TMP=$G(@RORREF@(9,RORFYIEN,0,.01,"E"))
 . Q:TMP=""
 . D SETOBX(RORFYID,,TMP,$G(@RORREF@(9,RORFYIEN,0,1,"I")))
 . ;---
 . S FYIEN=""
 . F  S FYIEN=$O(@RORREF@(9,RORFYIEN,1,FYIEN))  Q:FYIEN=""  D
 . . S TMP=$G(@RORREF@(9,RORFYIEN,1,FYIEN,0,.01,"E"))
 . . D:TMP'="" SETOBX(RORFYCM,,TMP)
 Q
 ;
BACSP ;***** Bacteriology Smear/Prep
 ;
 N RORBSPID,RORBSP
 S RORBSPID=$$SEGID("BACT-SP","Bact Smear/Prep",CS)
 ;
 S RORBSP=""
 F  S RORBSP=$O(@RORREF@(25,RORBSP))  Q:'RORBSP  D
 . S TMP=$G(@RORREF@(25,RORBSP,0,.01,"E"))
 . D:TMP'="" SETOBX(RORBSPID,,TMP)
 Q
 ;
MYCO ;***** Mycobacterium
 N RORMYD,RORMYD1,RORDF,RORDO,RORMYIEN,RORMYID,RORMYCM,MYIEN,RORMYF,RORMYO,TMP,TMP1
 S RORMYID=$$SEGID("MYCO","Mycobacterium",CS)
 S RORMYCM=$$SEGID("MYCOC","Myco Comment",CS)
 S RORMYF=$$SEGID("MYCOAF","Myco Anti-F",CS)
 S RORMYO=$$SEGID("MYCOAO","Myco Anti-O",CS)
 ;
 S RORMYIEN=""
 F  S RORMYIEN=$O(@RORREF@(12,RORMYIEN))  Q:'RORMYIEN  D
 . S TMP=$G(@RORREF@(12,RORMYIEN,0,.01,"E"))
 . Q:TMP=""
 . D SETOBX(RORMYID,,TMP,$G(@RORREF@(12,RORMYIEN,0,1,"I")))
 . ;---
 . S MYIEN=""
 . F  S MYIEN=$O(@RORREF@(12,RORMYIEN,1,MYIEN))  Q:MYIEN=""  D
 . . S TMP=$G(@RORREF@(12,RORMYIEN,1,MYIEN,0,.01,"E"))
 . . D:TMP'="" SETOBX(RORMYCM,,TMP)
 . ;
 . S RORMYD=2
 . F  S RORMYD=$O(@RORREF@(12,RORMYIEN,0,RORMYD)) Q:'RORMYD!(RORMYD'<3)  D
 . . S TMP=$G(@RORREF@(12,RORMYIEN,0,RORMYD,"I"))  Q:TMP?."^"
 . . D SETOBX(RORMYF,$P(TMP,U),$P(TMP,U,2))
 . ;
 . S RORMYD1=4
 . F  S RORMYD1=$O(@RORREF@(12,RORMYIEN,0,RORMYD1)) Q:'RORMYD1!(RORMYD1'<56)  D
 . . S TMP=$G(@RORREF@(12,RORMYIEN,0,RORMYD1,"I"))  Q:TMP?."^"
 . . D SETOBX(RORMYO,$P(TMP,U),$P(TMP,U,2))
 Q
 ;
MYCOSP ;***** Mycology Smear Prep
 ;
 N RORMSPID,RORMSPIN
 S RORMSPID=$$SEGID("MYCO-SP","Mycology Smear/Prep",CS)
 ;
 S RORMSPIN=""
 F  S RORMSPIN=$O(@RORREF@(15,RORMSPIN))  Q:'RORMSPIN  D
 . S TMP=$G(@RORREF@(15,RORMSPIN,0,.01,"E"))
 . D:TMP'="" SETOBX(RORMSPID,,TMP)
 Q
 ;
 ;***** MICROBIOLOGY OBX SEGMENT(S) BUILDER
 ;
 ; RORREF        Global reference for MI entry
 ;
 ; Return Values:
 ;       <0  Error code
 ;        0  Ok
 ;       >0  Non-fatal error(s)
 ;
OBX(RORREF) ;
 N CS,ERRCNT,RORTBST,IEN,RC,RORID,TMP
 S (ERRCNT,RC)=0
 D ECH^RORHL7(.CS)
 ;
 ;--- Process TB data if Final report
 S RORTBST=$G(@RORREF@(0,23,"I"))
 I RORTBST="F" D
 . N RORTBDTE,RORTBAFS,RORTBQTY
 . S RORID=$$SEGID("AFB-SP","TB Report",CS)
 . S RORTBDTE=$$FM2HL^RORHL7($G(@RORREF@(0,22,"I")))
 . S RORTBAFS=$G(@RORREF@(0,24,"I"))
 . S RORTBQTY=$G(@RORREF@(0,25,"I"))
 . D SETOBX(RORID,,RORTBST,RORTBQTY,RORTBAFS,,RORTBDTE)
 ;
 ;--- Get Bact RPT Remark Data
 S RORID=$$SEGID("BACT","Bact",CS)
 S IEN=""
 F  S IEN=$O(@RORREF@(4,IEN))  Q:'IEN  D
 . S TMP=$G(@RORREF@(4,IEN,0,.01,"E"))
 . D:TMP'="" SETOBX(RORID,,TMP)
 ;
 ;--- Get Gram Stain Data
 S RORID=$$SEGID("GRAM","Gram Stain",CS)
 S IEN=""
 F  S IEN=$O(@RORREF@(2,IEN))  Q:'IEN  D
 . S TMP=$G(@RORREF@(2,IEN,0,.01,"E"))
 . D:TMP'="" SETOBX(RORID,,TMP)
 ;
 D ORGDATA  ; Organism Data
 D PARDATA  ; Parasite Data
 D FUNGUS   ; Fungus/Yeast Data
 D MYCO     ; Mycobacterium Data
 D VIRUS    ; Virus Data
 D PARASP   ; Parasitology Smear/Prep
 D BACSP    ; Bacteriology Smear/Prep
 D MYCOSP   ; Mycology Smear Prep
 D VIRORPT  ; Virology RPT Remark
 ;
 ;--- Parasite Remark
 S RORID=$$SEGID("PARP","Parasite Remark",CS)
 S IEN=""
 F  S IEN=$O(@RORREF@(7,IEN))  Q:IEN=""  D
 . S TMP=$G(@RORREF@(7,IEN,0,.01,"E"))
 . D:TMP'="" SETOBX(RORID,,TMP)
 ;
 ;--- Specimen Comments
 S TMP=$G(@RORREF@(0,.99,"E"))
 I TMP'=""  D  D SETOBX(RORID,,TMP)
 . S RORID=$$SEGID("COMP","Specimen Comment",CS)
 ;
 Q $S(RC<0:RC,1:ERRCNT)
 ;
 ;***** PROCESSES ORGANISM DATA
ORGDATA ;
 N IEN,RORANTID,RORCMID,RORID,RORMBC,RORMIC,RORORIEN,RORAINX,RORAINX1,RORANTIF,RORANTIO,TMP,TMP1
 S RORID=$$SEGID("ORG","Organism",CS)
 S RORCMID=$$SEGID("ORGC","Org Comment",CS)
 S RORANTID=$$SEGID("ORGA","Org Antibiotic",CS)
 S RORANTIF=$$SEGID("ORGAF","Org Antibiotic-F",CS)
 S RORANTIO=$$SEGID("ORGAO","Org Antibiotic-O",CS)
 ;---
 S RORORIEN=""
 F  S RORORIEN=$O(@RORREF@(3,RORORIEN))  Q:'RORORIEN  D
 . S TMP=$G(@RORREF@(3,RORORIEN,0,.01,"E"))
 . Q:TMP=""
 . D SETOBX(RORID,,TMP,$G(@RORREF@(3,RORORIEN,0,1,"I")))
 . ;---
 . S RORAINX=2
 . F  S RORAINX=$O(@RORREF@(3,RORORIEN,0,RORAINX)) Q:'RORAINX!(RORAINX'<3)  D
 . . S TMP=$G(@RORREF@(3,RORORIEN,0,RORAINX,"I"))  Q:TMP?."^"
 . . D SETOBX(RORANTIF,$P(TMP,U),$P(TMP,U,2))
 . ;---
 . S RORAINX1=10
 . F  S RORAINX1=$O(@RORREF@(3,RORORIEN,0,RORAINX1)) Q:'RORAINX1!(RORAINX1'<160)  D
 . . S TMP=$G(@RORREF@(3,RORORIEN,0,RORAINX1,"I"))  Q:TMP?."^"
 . . D SETOBX(RORANTIO,$P(TMP,U),$P(TMP,U,2))
 . ;---
 . S IEN=""
 . F  S IEN=$O(@RORREF@(3,RORORIEN,1,IEN))  Q:IEN=""  D
 . . S TMP=$G(@RORREF@(3,RORORIEN,1,IEN,0,.01,"E"))
 . . D:TMP'="" SETOBX(RORCMID,,TMP)
 . ;---
 . S IEN=""
 . F  S IEN=$O(@RORREF@(3,RORORIEN,3,IEN))  Q:IEN=""  D
 . . S TMP=$G(@RORREF@(3,RORORIEN,3,IEN,0,.01,"E"))
 . . Q:TMP=""
 . . S RORMIC=$G(@RORREF@(3,RORORIEN,3,IEN,0,1,"E"))
 . . S RORMBC=$G(@RORREF@(3,RORORIEN,3,IEN,0,2,"E"))
 . . D SETOBX(RORANTID,,TMP,,RORMIC,RORMBC)
 Q
 ;
PARASP ;***** Parasitology Smear/Prep
 ;
 N RORPSPID,RORPSP
 S RORPSPID=$$SEGID("PARA-SP","Para Smear/Prep",CS)
 ;
 S RORPSP=""
 F  S RORPSP=$O(@RORREF@(24,RORPSP))  Q:'RORPSP  D
 . S TMP=$G(@RORREF@(24,RORPSP,0,.01,"E"))
 . D:TMP'="" SETOBX(RORPSPID,,TMP)
 Q
 ;
 ;***** PROCESSES PARASITE DATA
PARDATA ;
 N IEN,RORPCMID,RORPSID,RORPSIEN,RORSTID,RORSTIEN,RORSTQAN,TMP
 S RORPSID=$$SEGID("PAR","Parasite",CS)
 S RORSTID=$$SEGID("PARQ","Stage",CS)
 S RORPCMID=$$SEGID("PARC","Comment",CS)
 ;---
 S RORPSIEN=""
 F  S RORPSIEN=$O(@RORREF@(6,RORPSIEN))  Q:RORPSIEN=""  D
 . S TMP=$G(@RORREF@(6,RORPSIEN,"0",".01","E"))
 . Q:TMP=""
 . D SETOBX(RORPSID,,TMP)
 . ;---
 . S RORSTIEN=""
 . F  S RORSTIEN=$O(@RORREF@(6,RORPSIEN,1,RORSTIEN)) Q:RORSTIEN=""  D
 . . S TMP=$G(@RORREF@(6,RORPSIEN,1,RORSTIEN,0,.01,"I"))
 . . Q:TMP=""
 . . S RORSTQAN=$G(@RORREF@(6,RORPSIEN,1,RORSTIEN,0,"1","E"))
 . . D SETOBX(RORSTID,,TMP,RORSTQAN)
 . . ;---
 . . S IEN=""
 . . F  S IEN=$O(@RORREF@(6,RORPSIEN,1,RORSTIEN,1,IEN))  Q:IEN=""  D
 . . . S TMP=$G(@RORREF@(6,RORPSIEN,1,RORSTIEN,1,IEN,0,.01,"E"))
 . . . D:TMP'="" SETOBX(RORPCMID,,TMP)
 Q
 ;
 ;***** CREATES SEGMENT IDENTIFIER
SEGID(PONE,PTWO,CS) ;
 Q PONE_CS_PTWO_CS_"VA080"
 ;
 ;***** CREATES AND STORES THE OBX SEGMENT
SETOBX(OBX3,OBX4,OBX5,OBX6,OBX7,OBX13,OBX14) ;
 N RORSEG
 ;--- Initialize the segment
 S RORSEG(0)="OBX"
 ;--- OBX-2
 S RORSEG(2)="FT"
 ;--- OBX-3
 S RORSEG(3)=OBX3
 ;--- OBX-4, OBX-5, OBX-6, and OBX-7
 S:$G(OBX4)'="" RORSEG(4)=$$ESCAPE^RORHL7(OBX4)
 S:$G(OBX5)'="" RORSEG(5)=$$ESCAPE^RORHL7(OBX5)
 S:$G(OBX6)'="" RORSEG(6)=$$ESCAPE^RORHL7(OBX6)
 S:$G(OBX7)'="" RORSEG(7)=$$ESCAPE^RORHL7(OBX7)
 ;--- OBX-11
 S RORSEG(11)="F"
 ;--- OBX-13 and OBX-14
 S:$G(OBX13)'="" RORSEG(13)=$$ESCAPE^RORHL7(OBX13)
 S:$G(OBX14)'="" RORSEG(14)=OBX14
 ;--- Store the segment
 D ADDSEG^RORHL7(.RORSEG)
 Q
 ;
VIRORPT ;***** Virology RPT Remark
 N RORVRID,RORVRIEN
 S RORVRID=$$SEGID("VIRUSR","Virology RPT",CS)
 ;
 S RORVRIEN=""
 F  S RORVRIEN=$O(@RORREF@(18,RORVRIEN))  Q:'RORVRIEN  D
 . S TMP=$G(@RORREF@(18,RORVRIEN,0,.01,"E"))
 . D:TMP'="" SETOBX(RORVRID,,TMP)
 Q
 ;
VIRUS ;***** Virus
 ;
 N RORVIRID,RORVIIEN
 S RORVIRID=$$SEGID("VIRUS","Virus",CS)
 ;
 S RORVIIEN=""
 F  S RORVIIEN=$O(@RORREF@(17,RORVIIEN))  Q:'RORVIIEN  D
 . S TMP=$G(@RORREF@(17,RORVIIEN,0,.01,"E"))
 . D:TMP'="" SETOBX(RORVIRID,,TMP)
 Q
